/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.traits;

import com.sammy.malum.core.setup.content.AttributeRegistry;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerTools;
import team.lodestar.lodestone.setup.LodestoneAttributeRegistry;

public class SoulStained
extends NoLevelsModifier {
    private static final AttributeModifier HELMET_MAGIC_RESISTANCE = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.HEAD.m_20749_()], "Helmet Magic Resistance", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_MAGIC_RESISTANCE = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.CHEST.m_20749_()], "Chestplate Magic Resistance", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_MAGIC_RESISTANCE = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.LEGS.m_20749_()], "Leggings Magic Resistance", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BOOTS_MAGIC_RESISTANCE = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.FEET.m_20749_()], "Boots Magic Resistance", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier HELMET_SOUL_WARD_CAP = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.HEAD.m_20749_()], "Helmet Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_SOUL_WARD_CAP = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.CHEST.m_20749_()], "Chestplate Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_SOUL_WARD_CAP = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.LEGS.m_20749_()], "Leggings Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BOOTS_SOUL_WARD_CAP = new AttributeModifier(ArmorItem.f_40380_[EquipmentSlot.FEET.m_20749_()], "Boots Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier MELEE_PRIMARY_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("cd509ae0-3479-4665-b402-04e66c0ef3fd"), "Primary Magic Damage", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier AXE_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("353ec372-c40f-452b-8152-abace67ca5fd"), "Axe Magic Damage", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier HARVEST_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("4afa8ad7-bbb3-4c75-89c9-e488190790ba"), "Harvest Magic Damage", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier OFFHAND_MELEE_PRIMARY_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("39dc8581-cbc0-4e3b-a7cd-2a016685c7a7"), "Offhand Primary Magic Damage", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier OFFHAND_AXE_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("1d4c724e-3797-463f-9e82-3e881f3511c7"), "Offhand Axe Magic Damage", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier OFFHAND_HARVEST_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("8c109bf8-ed6e-4949-92cb-470c5e7b446f"), "Offhand Harvest Magic Damage", 2.0, AttributeModifier.Operation.ADDITION);

    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            this.changeEquipment(sp, context, false);
        }
    }

    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            this.changeEquipment(sp, context, true);
        }
    }

    public void changeEquipment(ServerPlayer sp, EquipmentChangeContext context, boolean remove) {
        AttributeInstance magicResistance = sp.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_RESISTANCE.get());
        AttributeInstance soulWardCap = sp.m_21051_((Attribute)AttributeRegistry.SOUL_WARD_CAP.get());
        AttributeInstance magicDamage = sp.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get());
        AttributeModifier magicResistanceModifier = null;
        AttributeModifier soulWardCapModifier = null;
        AttributeModifier magicDamageModifier = null;
        boolean isArmor = false;
        boolean isTool = false;
        ItemStack stack = remove ? context.getOriginal() : context.getReplacement();
        switch (context.getChangedSlot()) {
            case FEET: {
                isArmor = true;
                magicResistanceModifier = BOOTS_MAGIC_RESISTANCE;
                soulWardCapModifier = BOOTS_SOUL_WARD_CAP;
                break;
            }
            case LEGS: {
                isArmor = true;
                magicResistanceModifier = LEGGINGS_MAGIC_RESISTANCE;
                soulWardCapModifier = LEGGINGS_SOUL_WARD_CAP;
                break;
            }
            case CHEST: {
                isArmor = true;
                magicResistanceModifier = CHESTPLATE_MAGIC_RESISTANCE;
                soulWardCapModifier = CHESTPLATE_SOUL_WARD_CAP;
                break;
            }
            case HEAD: {
                isArmor = true;
                magicResistanceModifier = HELMET_MAGIC_RESISTANCE;
                soulWardCapModifier = HELMET_SOUL_WARD_CAP;
                break;
            }
            case OFFHAND: 
            case MAINHAND: {
                if (!stack.m_204117_(TinkerTags.Items.MELEE_OR_HARVEST)) break;
                isTool = true;
            }
        }
        if (isArmor) {
            if (magicResistance != null) {
                if (remove && magicResistance.m_22109_(magicResistanceModifier)) {
                    magicResistance.m_22130_(magicResistanceModifier);
                } else if (!magicResistance.m_22109_(magicResistanceModifier)) {
                    magicResistance.m_22125_(magicResistanceModifier);
                }
            }
            if (soulWardCap != null) {
                if (remove && soulWardCap.m_22109_(soulWardCapModifier)) {
                    soulWardCap.m_22130_(soulWardCapModifier);
                } else if (!soulWardCap.m_22109_(soulWardCapModifier)) {
                    soulWardCap.m_22125_(soulWardCapModifier);
                }
            }
        } else if (isTool) {
            if (stack.m_150930_(TinkerTools.broadAxe.m_5456_())) {
                magicDamageModifier = context.getChangedSlot() == EquipmentSlot.OFFHAND ? OFFHAND_AXE_MAGIC_DAMAGE : AXE_MAGIC_DAMAGE;
            } else if (stack.m_204117_(TinkerTags.Items.MELEE_PRIMARY)) {
                magicDamageModifier = context.getChangedSlot() == EquipmentSlot.OFFHAND ? OFFHAND_MELEE_PRIMARY_MAGIC_DAMAGE : MELEE_PRIMARY_MAGIC_DAMAGE;
            } else if (stack.m_204117_(TinkerTags.Items.MELEE_OR_HARVEST)) {
                magicDamageModifier = context.getChangedSlot() == EquipmentSlot.OFFHAND ? OFFHAND_HARVEST_MAGIC_DAMAGE : HARVEST_MAGIC_DAMAGE;
            }
            if (magicDamage != null && magicDamageModifier != null) {
                if (remove && magicDamage.m_22109_(magicDamageModifier)) {
                    magicDamage.m_22130_(magicDamageModifier);
                } else if (!magicDamage.m_22109_(magicDamageModifier)) {
                    magicDamage.m_22125_(magicDamageModifier);
                }
            }
        }
    }
}

